// CardHolderSearch.cpp : implementation file
//

#include "stdafx.h"
#include "db_apivcclient.h"
#include "CardHolderSearch.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CCardHolderSearch dialog


CCardHolderSearch::CCardHolderSearch(CWnd* pParent /*=NULL*/)
	: CDialog(CCardHolderSearch::IDD, pParent)
{
	//{{AFX_DATA_INIT(CCardHolderSearch)
	m_sData = _T("");
	m_iOperator = -1;
	//}}AFX_DATA_INIT
}


CCardHolderSearch ::CCardHolderSearch(IApplication *pApp):CDialog(CCardHolderSearch::IDD, NULL)
{
	pApplication = pApp;
}


void CCardHolderSearch::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCardHolderSearch)
	DDX_Control(pDX, IDC_FIELDLIST, m_FieldList);
	DDX_Control(pDX, IDC_CHLISTVIEW, m_CHList);
	DDX_Control(pDX, IDC_ACCTLIST, m_AcctList);
	DDX_Control(pDX, IDC_SUBACCTLIST2, m_SubAcctList);
	DDX_Text(pDX, IDC_EDIT_DATA, m_sData);
	DDX_CBIndex(pDX, IDC_OPERATORLIST, m_iOperator);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CCardHolderSearch, CDialog)
	//{{AFX_MSG_MAP(CCardHolderSearch)
	ON_CBN_SELCHANGE(IDC_ACCTLIST, OnSelchangeAcctlist)
	ON_CBN_SELCHANGE(IDC_SUBACCTLIST2, OnSelchangeSubAcctlist)
	ON_BN_CLICKED(IDC_BTN_SEARCH, OnBtnSearch)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCardHolderSearch message handlers

void CCardHolderSearch::OnSelchangeAcctlist() 
{
	// TODO: Add your control notification handler code here
	m_FieldList.ResetContent();
	m_SubAcctList.ResetContent();
	//LoadSearchFields();
	LoadSubAccounts();
}

void CCardHolderSearch::OnSelchangeSubAcctlist() 
{
	// TODO: Add your control notification handler code here
	m_FieldList.ResetContent();
	LoadSearchFields();
}

void CCardHolderSearch::OnBtnSearch() 
{
	UpdateData();
	
	m_CHList.DeleteAllItems();

	BSTR bstrAcctName;
	BSTR bstrSubAcctName;
	//select account name 
		int index_Account = m_AcctList.GetCurSel();
		CString sAcctName;
		if (index_Account <0)
			bstrAcctName = SysAllocString(L"");
		else
		{
			m_AcctList.GetLBText(index_Account,sAcctName);
			bstrAcctName = sAcctName.AllocSysString();
		}
		
		//select Sub account name 
		int index_SubAccount = m_SubAcctList.GetCurSel();
		CString sSubAcctName;
		if (index_SubAccount <0)
			bstrSubAcctName = SysAllocString(L"");
		else
		{
			m_SubAcctList.GetLBText(index_SubAccount,sSubAcctName);
			bstrSubAcctName = sSubAcctName.AllocSysString();
		}

	COleSafeArray saSearchFields, saSearchOps, saSearchData;
	_variant_t vFields, vOps, vData;
	vFields.Clear();
	vOps.Clear();
	vData.Clear();
	
	saSearchFields.CreateOneDim(VT_BSTR, 1);
	saSearchOps.CreateOneDim(VT_I4, 1);
	saSearchData.CreateOneDim(VT_BSTR, 1);
	
	int index_Field = m_FieldList.GetCurSel();
	if(index_Field<0)
	{
		return;
	}
	CString sFieldName;
	long lCount =0;
	m_FieldList.GetLBText(index_Field,sFieldName);
	BSTR bstrFieldName = sFieldName.AllocSysString();
	saSearchFields.PutElement(&lCount, bstrFieldName);
	vFields = saSearchFields.Detach();

	saSearchOps.PutElement(&lCount, (void *) &m_iOperator);
	vOps = saSearchOps.Detach();

	BSTR bstrData;
	if(m_sData.IsEmpty())
	{
		return;
	}

	bstrData = m_sData.AllocSysString();
	saSearchData.PutElement(&lCount, bstrData);
	vData = saSearchData.Detach();

	_variant_t vCardHolders;
	vCardHolders.Clear();

	pApplication->GetCardHoldersOnSearch(bstrAcctName, bstrSubAcctName, vFields, vData, vOps, &vCardHolders);
	
	if(vCardHolders.vt == VT_EMPTY)
	{
		AfxMessageBox(L"No CardHolders matching the Criteria");
		return;
	}

	long uBound =0 ;
	ICardHolder *pCH = NULL;
	
	COleSafeArray sa(vCardHolders);
	sa.GetUBound(1,&uBound);

	CString sNum;
	sNum.Format(_T("No of Card Holders Found : %ld"), uBound+1);
	AfxMessageBox(sNum);

	for(long i =0 ;i <= uBound ; i++)			
	{
		IDispatch *pDisp = NULL;
		sa.GetElement(&i,(void*)&pDisp);
		HRESULT hr = pDisp->QueryInterface(IID_ICardHolder,(void**)&pCH);
		if (pCH != NULL)
		{
			int nListViewCounter=m_CHList.GetItemCount();

			// Get Card ID
			CString szCHID;
			szCHID.Format(L"%ld",pCH->CardHolderID);
			m_CHList.InsertItem(nListViewCounter,szCHID);
			
			m_CHList.SetItemText(nListViewCounter,1,pCH->FirstName);
			m_CHList.SetItemText(nListViewCounter,2,pCH->LastName);
		
			pCH->Release();
		}
		pDisp->Release();
	}
	

	UpdateData(FALSE);
}

BOOL CCardHolderSearch::OnInitDialog() 
{
	CDialog::OnInitDialog();


	m_CHList.InsertColumn(0,_T("Card Holder ID"),LVCFMT_LEFT,25);
	m_CHList.InsertColumn(1,_T("First Name"),LVCFMT_LEFT,75);
	m_CHList.InsertColumn(2,_T("Last Name"),LVCFMT_LEFT,75);
	
	m_CHList.SetExtendedStyle(LVS_EX_FULLROWSELECT);

	m_AcctList.ResetContent();
	
	LoadAccounts();
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CCardHolderSearch::LoadAccounts()
{
	_variant_t vAccounts;
	vAccounts.Clear();
	pApplication->GetAccounts(&vAccounts); // get account details in WP-CS database server
	
	if(vAccounts.vt ==  VT_EMPTY)
	{
		return;
	}
	
	long uBound =0 ;
	IAccount *pAccount = NULL;
	
	COleSafeArray sa(vAccounts);
	sa.GetUBound(1,&uBound);
	UpdateData(TRUE);
	for(long i =0 ;i <= uBound ; i++)
		
	{
		IDispatch *pDisp = NULL;
		sa.GetElement(&i,(void*)&pDisp);
		HRESULT hr = pDisp->QueryInterface(IID_IAccount,(void**)&pAccount);
		if (pAccount != NULL)
		{
			m_AcctList.SetItemData(m_AcctList.AddString(pAccount->AccountName),pAccount->AccountID);
			pAccount->Release();
		}
		pDisp->Release();
	}
	UpdateData(FALSE);
	m_AcctList.SetCurSel(0);
}

void CCardHolderSearch :: LoadSubAccounts()
{
		_variant_t vSubAccounts;
		vSubAccounts.Clear();
				
		//select AccountID
		int index_Acct = m_AcctList.GetCurSel();		
		long lAccountID = m_AcctList.GetItemData(index_Acct);	

		if(lAccountID <= 0)
		{
			AfxMessageBox(L"Select Account!");
			return;
		}
		pApplication->GetSubAccountsByAccountID(lAccountID, &vSubAccounts); // get account details in WP-CS database server
		
		if(vSubAccounts.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0, lBound ;
		IAccount *pSubAccount= NULL;
		
		COleSafeArray sa(vSubAccounts);
		sa.GetUBound(1,&uBound);
		sa.GetLBound(1,&lBound);
		UpdateData(TRUE);
		for(long i =lBound ;i <= uBound ; i++)		
		{			
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_IAccount,(void**)&pSubAccount);
			if (pSubAccount!= NULL)
			{				
				m_SubAcctList.SetItemData(m_SubAcctList.AddString(pSubAccount->AccountName), pSubAccount->AccountID);
				pSubAccount->Release();
			}
			pDisp->Release();
		}
	UpdateData(FALSE);
	
	//m_AccountList.SetCurSel(0);
	
}

void CCardHolderSearch :: LoadSearchFields()
{
	BSTR bstrAcctName;
	BSTR bstrSubAcctName;
	//select account name 
		int index_Account = m_AcctList.GetCurSel();
		CString sAcctName;
		if (index_Account <0)
			bstrAcctName = SysAllocString(L"");
		else
		{
			m_AcctList.GetLBText(index_Account,sAcctName);
			bstrAcctName = sAcctName.AllocSysString();
		}
		
		//select Sub account name 
		int index_SubAccount = m_SubAcctList.GetCurSel();
		CString sSubAcctName;
		if (index_SubAccount <0)
			bstrSubAcctName = SysAllocString(L"");
		else
		{
			m_SubAcctList.GetLBText(index_SubAccount,sSubAcctName);
			bstrSubAcctName = sSubAcctName.AllocSysString();
		}
	
	_variant_t vFields;
	vFields.Clear();
	pApplication->GetCardHolderSearchFieldsByAccountName(bstrAcctName, bstrSubAcctName, &vFields);

	if(vFields.vt == VT_EMPTY)
	{
		AfxMessageBox(L"No Fields");
		return;
	}
		
	long uBound =0 ;
	
	COleSafeArray sa(vFields);
	sa.GetUBound(1,&uBound);
	UpdateData(TRUE);
	BSTR bField;
	for(long i =0 ;i <= uBound ; i++)
	{
		sa.GetElement(&i,(void*)&bField);
		CString sField = CString(bField);
		m_FieldList.AddString(sField);
	}
	
}